/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.mapui;

import filenet.vw.toolkit.utils.mapui.VWBaseStepUI;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;

final class VWDesignerDraggedRouteUI
extends JComponent {
    private Point m_srcPt = null;
    private Point m_destPt = null;
    private VWBaseStepUI m_srcStep = null;

    public VWDesignerDraggedRouteUI(VWBaseStepUI srcStep) {
        this.m_srcStep = srcStep;
        this.m_srcPt = srcStep.getImageCenterLocation();
        this.m_destPt = new Point(this.m_srcPt);
        Rectangle rect = new Rectangle(this.m_srcPt.x, this.m_srcPt.y, 0, 0);
        rect.width = 0;
        rect.height = 0;
        this.setBounds(rect);
    }

    public void mouseDragged(Point loc) {
        this.m_destPt.x = loc.x;
        this.m_destPt.y = loc.y;
        Rectangle rect = this.getBounds();
        rect.x = this.m_srcPt.x <= loc.x ? this.m_srcPt.x - 1 : loc.x - 1;
        rect.y = this.m_srcPt.y <= loc.y ? this.m_srcPt.y - 1 : loc.y - 1;
        rect.width = Math.abs(loc.x - this.m_srcPt.x) + 2;
        rect.height = Math.abs(loc.y - this.m_srcPt.y) + 2;
        this.setBounds(rect);
    }

    public void paintComponent(Graphics g) {
        Color curColor = g.getColor();
        g.setColor(Color.black);
        g.drawLine(this.m_srcPt.x, this.m_srcPt.y, this.m_destPt.x, this.m_destPt.y);
        g.setColor(curColor);
        this.m_srcStep.paintComponent(g);
    }

    public VWBaseStepUI getSrcStep() {
        return this.m_srcStep;
    }
}

